<?php /* Smarty version 2.6.26, created on 2010-03-10 10:51:52
         compiled from str:content.tpl */ ?>
<h3>Pierwszy wykres w Google Chart API</h3>

<p>
Po umieszczeniu na stronie WWW znacznika:
</p>

<pre>
&lt;img src="http://chart.apis.google.com/chart?chs=400x200&amp;cht=p3&amp;chd=t:1,5&amp;chl=Węże|Żółwie" /&gt;
</pre>

<p>
otrzymasz wykres przedstawiony na rysunku 1.
</p>

<?php echo $this->_tpl_vars['figures'][1]; ?>


<p>
W tak prosty sposób działa usługa o nazwie Google Chart API.
Osadzanie wykresów na stronie WWW sprowadza się
do przygotowania odpowiedniego adresu URL, 
który będzie zawierał dane i ustalał właściwości wykresu.
Nie wymaga to ani instalacji żadnego oprogramowania
ani nawet rejestracji i uzyskiwania kluczy dostępu do usługi.
Rozwiązanie takie jest niezależne od platformy
sprzętowej i stosowanego oprogramowania.
Równie dobrze może być wykorzystywane 
na statycznych stronach WWW,
w skryptach PHP, Perla czy ASP.
Dodatkowym plusem jest licencja,
która pozwala na wykorzystywanie Google Chart API
do dowolnych celów bez ograniczeń transferu.
</p>

<p>
Działanie Google Chart API możemy sprawdzić w praktyce
odwiedzając serwis Google Finance
(<a href="http://finance.google.com/finance">http://finance.google.com/finance</a>).
Wszystkie widoczne tam wykresy są generowane 
z wykorzystaniem Google Chart API.
Jeśli chcesz się dowiedzieć, w jaki sposób 
wykres został wykonany, to &mdash; korzystając z Firefoksa &mdash;
kolejno:
</p>

<ul>
<li>kliknij w wykres prawym przyciskiem myszy,</li>
<li>z menu kontekstowego wybierz opcję <span class="option">Pokaż obrazek</span>
(rysunek 2).</li>
</ul>


<p>
Wówczas przeglądarka Firefox wyświetli wyłącznie wykres,
a w pasku adresu widoczny będzie URL wykresu,
zawierający wszystkie parametry (rysunek 3).
</p>

<?php echo $this->_tpl_vars['figures'][2]; ?>


<?php echo $this->_tpl_vars['figures'][3]; ?>


<h3>Adresy URL</h3>

<p>
Analizując adres użyty w pierwszym przykładzie 
możemy wyodrębnić następujące fragmenty:
</p>

<pre>
http://chart.apis.google.com/chart?
    chs=400x200&amp;
    cht=p3&amp;
    chd=t:1,5&amp;
    chl=Węże|Żółwie
</pre>


<p>
Bazowym adresem usługi Chart API jest więc:
</p>


<pre>
http://chart.apis.google.com/chart
</pre>



<p>
Po nim umieszczamy znak zapytania i serię parametrów 
oddzielonych znakiem <span class="variable">&amp;</span>
(ich kolejność może być dowolna).
Pierwszy z użytych parametrów ustala wymiary wykresu.
Pisząc:
</p>


<pre>
chs=400x200
</pre>



<p>
otrzymamy wykres, który jest obrazem PNG o szerokości 400 i wysokości 200 pikseli.
</p>


<?php echo $this->_tpl_vars['frames'][1]; ?>




<p>
Drugi parametr <span class="variable">cht</span> 
o wartości <span class="variable">p3</span> ustala typ wykresu.
Wykres oznaczany symbolem <span class="variable">p3</span> 
jest trójwymiarowym 
wykresem kołowym (ang. <em>pie chart</em>).
Kolejny parametr <span class="variable">chd</span> definiuje dane wykresu.
Zapis:
</p>


<pre>
chd=t:1,5
</pre>

<p>
powoduje, że pierwszy wycinek koła zajmie 1/6 część całości,
a drugi &mdash; 5/6.
Wreszcie ostatni z parametrów:
</p>

<pre>
chl=Węże|Żółwie
</pre>

<p>
zawiera etykiety wycinków koła.
Polskie znaki kodujemy w standardzie utf-8.
</p>

<?php echo $this->_tpl_vars['frames'][2]; ?>


<h3>Parametry wykresów</h3>

<p>
Trzy pierwsze parametry podane w 
omówionym przykładzie są obowiązkowe i zawsze muszą wystąpić.
Są to:
</p>


<ul>
<li><span class="variable">chs</span> &mdash; wymiary wykresu</li>
<li><span class="variable">cht</span>  &mdash; typ wykresu</li>
<li><span class="variable">chd</span> &mdash; dane wykresu</li>
</ul>


<p>
Pozostałe parametry są opcjonalne.
Ich występowanie zależy od rodzaju wykresu.
</p>


<ul>
<li><span class="variable">chco</span> (chart color) &mdash; kolory</li>
<li><span class="variable">chf</span> (chart fill) &mdash; tło, które może być gradientem lub zawierać pasy</li>
<li><span class="variable">chds</span> (data scaling) &mdash; skalowanie danych</li>
<li><span class="variable">chtt</span> (chart title) &mdash; tytuł</li>
<li><span class="variable">chdl</span> (chart legend) &mdash; legenda</li>
<li><span class="variable">chxt</span> (multiple axis labels) &mdash; etykiety osi</li>
<li><span class="variable">chg</span> (grid lines) &mdash; siatka</li>
<li><span class="variable">chm</span> (shape markers) &mdash; punkty</li>
<li><span class="variable">chls</span> (line styles) &mdash; styl linii</li>
<li><span class="variable">chbh</span> (bar width and spacing) &mdash; grubość słupków wykresów słupkowych</li>
<li><span class="variable">chp</span> (bar chart zero line) &mdash; położenie osi wykresu słupkowego</li>
<li><span class="variable">chl</span> (chart labels) &mdash; etykiety</li>
</ul>

<h3>Rodzaje wykresów</h3>


<p>
Usługa Google Chart API udostępnia dziewięć rodzajów wykresów.
Są to:
</p>


<ul>
<li>liniowe (ang. <em>line chart</em>) &mdash; typy <span class="variable">lc</span> oraz <span class="variable">lxy</span></li>
<li>kardiogramy (ang. <em>sparkline chart</em>) &mdash; typ <span class="variable">ls</span></li>
<li>słupkowe (ang. <em>bar chart</em>) &mdash; typy <span class="variable">bhs</span>, <span class="variable">bvs</span>, <span class="variable">bhg</span>, <span class="variable">bvg</span></li>
<li>kołowe (ang. <em>pie chart</em>) &mdash; typy <span class="variable">p</span> oraz <span class="variable">p3</span></li>
<li>diagramy Venna (ang. <em>Venn diagram</em>) &mdash; typ <span class="variable">v</span></li>
<li>wykresy bąbelkowe (ang. <em>scatter plot</em>) &mdash; typ <span class="variable">s</span></li>
<li>wykresy radarowe (ang. <em>radar chart</em>) &mdash; typ <span class="variable">r</span></li>
<li>mapy (ang. <em>map</em>) &mdash; typ <span class="variable">t</span></li>
<li>wskaźniki (org. <em>Google-o-meter</em>) &mdash; typ <span class="variable">gom</span></li>
</ul>


<p>
Każdy z rodzajów jest identyfikowany parametrem <span class="variable">cht</span>.
Na przykład 
diagram Venna będzie miał parametr 
<span class="variable">cht=v</span>, 
a wykres liniowy &mdash; <span class="variable">cht=lc</span> lub <span class="variable">cht=lxy</span>.
</p>

<h3>Kodowanie danych</h3>

<p>
Dane do wykresu mogą być zakodowane na jeden z czterech sposobów
nazywanych:
</p>

<ul>
<li>kodowaniem tekstowym,</li>
<li>kodowaniem tekstowym ze skalowaniem,</li>
<li>kodowaniem prostym,</li>
<li>oraz kodowaniem rozszerzonym.</li>
</ul>



<p>
W <em>kodowaniu tekstowym</em> wymieniamy wartości oddzielając je przecinkami.
Dopuszczalnymi wartościami są liczby od 0 do 100.
Do podziału danych na kilka serii stosujemy znak <span class="variable">|</span>:
</p>


<pre>
chd=t:10.0,58.0,95.0|30.0,8.0,63.0
</pre>



<p>
<em>Kodowanie tekstowe ze skalowaniem</em>
pozwala podać minimalne i maksymalne wartości w ciągach danych.
Dane zakodowane tekstowo (parametr <span class="variable">chd=t:</span>)
rozszerzamy o parametr <span class="variable">chds</span>, który podaje minimalną wartość 
w ciągu (w przykładzie: -80) oraz wartość maksymalną
(w przykładzie: 140):
</p>



<pre>
chd=t:30,-60,110&amp;chds=-80,140
</pre>


<p>
Obliczamy długość przedziału 140 * 80 = 220,
a następnie skalujemy podane wartości: 
</p>



<pre>
 30:   30+80 = 110,  110/220 * 100 = 50
-60:  -60+80 =  20,   20/220 * 100 =  9
110:  110+80 = 190,  190/220 * 100 = 86
</pre>


<p>
Zatem podany ciąg możemy przedstawić jako kodowanie tekstowe
bez skalowania:
</p>

<pre>
chd=t:50,9,86
</pre>


<p>
W <em>kodowaniu prostym</em> do zapisu wartości liczbowych 
stosujemy duże i małe litery alfabetu łacińskiego oraz cyfry.
Duże litery to wartości od 0 do 
25
(A=0, B=1, C=2, ..., Z=25),

małe litery kodują liczby od 26 do 51 
(a=26, b=27, c=28, ..., z=51),
zaś cyfry reprezentują wartości
od 52 do 61 (0=52, 1=53, 2=54, ..., 9=61).
Najmniejszą liczbą w tym ciągu jest 0,
a największą &mdash; 61.
</p>


<p>
Wartość <span class="variable">ATB19</span>:
</p>

<pre>
chd=s:ATb19
</pre>


<p>
reprezentuje ciąg
0 (A), 19 (T), 27 (b), 53 (1), 61 (9).
Po przeliczeniu:
</p>




<pre>
 0/61 * 100 = 0
19/61 * 100 = 31
27/61 * 100 = 44
53/61 * 100 = 87
61/61 * 100 = 100
</pre>



<p>
otrzymamy następujący kod tekstowy:
</p>


<pre>
chd=t:0,31,44,87,100
</pre>


<p>
W przypadku kodowania prostego serie danych oddzielamy znakiem przecinka,
np.:
</p>


<pre>
chd=s:ATb19,Mn5tz 
</pre>


<p>
Ostatni rodzaj kodowania, <em>kodowanie rozszerzone</em>,
do reprezentacji wartości liczbowych
wykorzystuje dwuznakowe kombinacje liter, cyfr oraz znaków 
kropki, przecinka, dywizu i podkreślenia.
Oto, w jaki sposób kombinacje znaków odpowiadają wartościom liczbowym:
</p>

<pre>
AA =  0,  AB =  1,  ...  AZ = 25,
Aa = 26,  Ab = 27,  ...  Az = 51,
A0 = 52,  A1 = 53,  ...  A9 = 61
A- = 62   A. = 63

BA =  64,  BB =  65,  ... 

...
</pre>



<p>
Wartością najmniejszą jest AA (0), 
a największą .. (4095).
Wartości te przeliczamy podobnie jak kodowanie proste,
tym razem jednak liczby dzielimy przez 4095.
</p>


<p>
Parametr:
</p>


<pre>
chd=e:C99AKA
</pre>





<p>
reprezentuje ciąg wartości 189 (C9), 3904 (9A),
640 (KA).
Po przeliczeniu:
</p>

<pre>
189/4095 * 100 = 5
3904/4095 * 100 = 95
640/4095 * 100 = 16
</pre>


<p>
ten sam ciąg możemy zakodować tekstowo:
</p>


<pre>
chd=t:5,95,16
</pre>




<p>
Do konwersji danych liczbowych na 
kodowanie proste można wykorzystać funkcję 
<span class="variable">simpleEncode()</span>
przedstawioną na listingu 1.
Sposób konwersji tablicy wartości do kodowania prostego,
wykorzystujący 
funkcję <span class="variable">simpleEncode()</span>
oraz bibliotekę jQuery
został przedstawiony na listingu 2.
</p>

<?php echo $this->_tpl_vars['listings'][1]; ?>


<?php echo $this->_tpl_vars['listings'][2]; ?>





<h3>Przykłady</h3>

<h4>Przykład pierwszy</h4>

<?php echo $this->_tpl_vars['figures'][4]; ?>


<p>
Wykres widoczny na rysunku 6 ma parametry:
</p>

<pre>
cht=bvs
chd=s:YUVmw1
chco=0000FF
chs=200x100
chtt=Poziom+sprzeda%C5%BCy
chts=00aaFF,16
chbh=20,8
</pre>


<p>
Jest to wykres słupkowy pionowy (<span class="variable">cht=bvs</span>)
o wymiarach 200x100 (<span class="variable">chs=200x100</span>),
którego dane zostały zakodowany w sposób prosty 
(<span class="variable">chd=s:</span>).
Słupki mają szerokość 20 pikseli i są odległe 
od siebie o 8 pikseli (<span class="variable">chbh=20,8</span>).
Kolor słupków jest niebieski (<span class="variable">chco=0000FF</span>).
Tytuł wykresu jest ustalony parametrami 
<span class="variable">chtt</span> oraz 
<span class="variable">chts</span>.
Pierwszy z nich zawiera tekst <em>Poziom sprzedaży</em>
(spacje kodujemy znakiem <span class="variable">+</span>),
a drugi ustala kolor (<span class="variable">00aaFF</span>) oraz wielkość czcionki
(16 pikseli).
</p>



<p>
Tytuł wykresu jest ustalony parametrem <span class="variable">chtt</span>.
</p>



<h4>Przykład drugi</h4>

<?php echo $this->_tpl_vars['figures'][5]; ?>



<p>
Wykres liniowy z rysunku 5 powstaje po ustaleniu następujących parametrów:
</p>


<pre>
cht=lc
chs=400x300
chd=s:pqokeYONOMEBAKPOQVTXZdecaZcglprqxuux393ztpoonkeggjp
chco=FF0000
chls=6
chxt=x,y
chxl=0:|Jun|July|Aug|1:||20|30|40|50
chf=bg,s,efefef
</pre>



<p>
Linia wykresu ma grubość 6 pikseli 
(<span class="variable">chls=6</span>) i czerwony kolor (<span class="variable">chco=FF0000</span>).
Wykres ma etykiety obu osi (<span class="variable">chxt=x,y</span>).
Treść etykiet jest ustalona w parametrze <span class="variable">chxl</span>.
Tło obrazu jest wypełnione szarym kolorem
(<span class="variable">chf=bg,s,efefef</span>).
</p>


<h4>Przykład trzeci</h4>

<?php echo $this->_tpl_vars['figures'][6]; ?>



<p>
Wykres liniowy z rysunku 6 ma parametry:
</p>


<pre>
cht=lxy
chs=500x300
chd=t:10,30,60,70,90,95,100|20,30,40,50,60,70,80|10,30,40,45,52|30,90,40,20,10|-1|5,33,50,55,7
chco=3072F3,ff0000,00aaaa
chls=2,4,1
chm=s,FF0000,0,-1,8|c,0000ff,1,-1,15|a,00aa00,2,-1,5
</pre>



<p>
Parametr <span class="variable">chd</span> 
definiuje trzy serie danych, zakodowane tekstowo.
Pierwszą serię tworzą punkty o współrzędnych:
</p>


<pre>
(10,20) (30,30) (60,40)
(70,50) (90,60) (95,70)
(100,80)
</pre>


<p>
Powstają one przez połączenie dwóch pierwszych ciągów:
<span class="variable">10,30,60,70,90,95,100</span>
oraz <span class="variable">20,30,40,50,60,70,80</span>.
</p>


<p>
Drugą serię tworzą punkty:
</p>



<pre>
(10,30) (30,90) (40,40) ...
</pre>



<p>
Natomiast punkty trzeciej serii są równo oddzielone na osi X
(wartość -1). Ich wartości na osi Y to
5,33,50,55,7.
</p>


<p>
Kolory i grubość poszczególnych linii wykresu 
ustalamy parametrami <span class="variable">chco</span> oraz <span class="variable">chls</span>.
</p>


<p>
Ostatni parametr <span class="variable">chm</span> definiuje markery 
umieszczone na liniach wykresu.
Typ markera oznaczamy literą,
np. 
<span class="variable">s</span> jest prostokątem,
<span class="variable">c</span> &mdash; krzyżykiem,
zaś <span class="variable">a</span> &mdash; strzałką.
Parametr:
</p>


<pre>
a,00aa00,2,-1,5
</pre>



<p>
definiuje marker w kształcie strzałki (<span class="variable">a</span>),
koloru zielonego (<span class="variable">00aa00</span>)
dla drugiej serii danych.
Markery będą umieszczone na wszystkich punktach 
serii danych (wartość -1).
Marker będzie miał rozmiar 5.
Jeśli zechcesz umieścić jeden marker 
w kształcie krzyżyka czerwonego koloru o wielkości 12
pomiędzy trzecim a czwartym punktem piątej serii danych
użyj parametru:
</p>



<pre>
c|ff0000|5|3.5|12
</pre>





<h4>Przykład czwarty</h4>

<?php echo $this->_tpl_vars['figures'][7]; ?>



<p>
Przykład czwarty, przedstawiony na rysunku 7, 
prezentuje wykres bąbelkowy.
Parametrami wykresu są:
</p>

<pre>
cht=s
chs=400x300
chd=t:10,20,60,90|10,60,5,90|100,40,60,90
chxt=x,y
chxl=0:|0|1|2|3|4|5|6|7|8|9|10|1:|0|25|50|75|100
chm=o,000000,1,-1,30
chf=c,lg,90,76A4FB,0.5,ffffff,0|bg,s,EFEFEF
</pre>


<p>
Trzy serie danych wykresu interpretujemy 
jako cztery następujące punkty:
</p>

<ul>
<li>punkt o współrzędnych (10,10) i wielkości 100</li>
<li>punkt o współrzędnych (20,60) i wielkości 40</li>
<li>punkt o współrzędnych (60,5) i wielkości 60</li>
<li>punkt o współrzędnych (90,90) i wielkości 90</li>
</ul>


<p>
Maksymalna wielkość punktu jest ustalana 
parametrem <span class="variable">chm</span>.
Punkty będą okręgami (<span class="variable">o</span>)
koloru czarnego (<span class="variable">000000</span>)
o maksymalnej wielkości 30 pikseli.
</p>


<p>
Tło wykresu i gradient są ustalone parametrem <span class="variable">chf</span>.
Cały obraz ma jednolite tło o kolorze szarym (<span class="variable">bg,s,EFEFEF</span>).
Natomiast obszar wykresu jest wypełniony liniowym gradientem :
</p>


<pre>
c      - obszar wykresu
lg     - gradient liniowy
90     - kąt gradientu (gradient pionowy)
76A4FB - kolor początkowy gradientu
0.5    - gradient rozpoczyna się w połowie wykresu
ffffff - kolor końcowy gradientu
0      - gradient trwa do dolnej krawędzi wykresu
</pre>



<p>
Wykres zawiera etykiety obu osi (<span class="variable">chxt</span>).
Liczby wyświetlane na osiach 
są dwoma seriami danych
zdefiniowanymi parametrem <span class="variable">chxl</span>:
</p>




<h4>Przykład piąty</h4>

<?php echo $this->_tpl_vars['figures'][8]; ?>



<p>
Na rysunku 8 przedstawiony jest wykres liniowy
z legendą.
Użyte parametry to:
</p>


<pre>
cht=lc
chs=400x300
chd=s:93zy...
chls=3,6,4|1,1,0
chdl=Niebieskie|Czerwone
chco=0000ff,ff0000
chxt=x,y
</pre>


<p>
Legendę dodajemy parametrem <span class="variable">chdl</span>
zaś styl linii ustalamy parametrem <span class="variable">chls</span>.
Wartość <span class="variable">3,6,4</span>
to pogrubiona linia przerywana.
Grubość linii wynosi 6,
pojedyncza kreska ma 6 pikseli, a przerwa między kreskami &mdash; 4 piksele.
Druga linia ma grubość 1 i jest ciągła 
(<span class="variable">1,1,0</span>).
</p>



<h4>Przykład szósty</h4>

<?php echo $this->_tpl_vars['figures'][9]; ?>



<p>
Wykres umieszczony na rysunku 6 powstał 
przy użyciu parametrów:
</p>

<pre>
cht=bhs
chs=400x400
chd=t:10,40,60|10,15,30
chco=4d89f9,c6d9fd
chg=10,20,1,4
chxt=y,x
chxl=0:|Marzec|Luty|Styczeń|1:|0|20|40|60|80|100
chbh=60,40
</pre>



<p>
Dwie serie danych służą do ustalenia wysokości 
słupków. Pierwsza seria definiuje wysokości ciemniejszych 
fragmentów słupków, a druga &mdash; jaśniejszych.
</p>


<p>
Siatka wykresu jest rysowana dzięki parametrowi <span class="variable">chg</span>.
Poziome odstępy wynoszą 10, a pionowe &mdash; 20.
Linia siatki jest przerywana w stosunku 1 do 4.
</p>




<h4>Przykład siódmy</h4>

<?php echo $this->_tpl_vars['figures'][10]; ?>


<p>
Wykres radarowy z rysunku 10 ma parametry:
</p>

<pre>
cht=r
chs=400x400
chd=t:77,66,15,0,31,48,100,77|20,36,100,2,0,100
chco=FF0000,FF9900
chls=2.0,4.0,0.0|2.0,4.0,0.0
chxt=x
chxl=0:|0|45|90|135|180|225|270|315
chxr=0,0.0,360.0
chg=25.0,25.0,4.0,4.0
chm=B,FF000080,0,1.0,5.0|B,FF990080,1,1.0,5.0
</pre>


<p>
Linia o kolorze czerwonym obrazuje pierwszą serię danych,
a pomarańczowa &mdash; drugą.
Obszary czerwony i pomarańczowy są zaznaczone parametrem <span class="variable">chm</span>.
Wartości kolorów zawierają trzy składowe oraz kanał alfa,
dzięki czemu wypełnienie jest nieco przezroczyste.
Pierwszy z kolorów
<span class="variable">FF000080</span>
to kolor czerwony (<span class="variable">FF0000</span>) 
o przezroczystości <span class="variable">80</span>.
</p>




<h4>Przykład ósmy</h4>

<?php echo $this->_tpl_vars['figures'][11]; ?>



<p>
Mapa przedstawiona na rysunku 11 ma parametry:
</p>


<pre>
cht=t
chs=440x220
chd=s:Af9
chco=ffffff,ffdfbf,512800
chld=PLDEFR
chtm=europe
chf=bg,s,EAF7FE
</pre>


<p>
Mapa przedstawia Europę (<span class="variable">chtm</span>).
Kolor morza ustalamy parametrem <span class="variable">chf</span>.
Kody państw, które należy pokolorować
są zawarte w parametrze <span class="variable">chld</span>.
Pokolorowano Polskę (<span class="variable">PL</span>), 
Niemcy (<span class="variable">DE</span>) i 
Francję (<span class="variable">FR</span>).
Wszystkie pozostałe Państwa mają kolor biały,
o czym decyduje pierwsza z wartości 
<span class="variable">ffffff</span>
parametru <span class="variable">chco</span>.
Kolor państw PL, DE oraz FR zależy od
wartości parametrów <span class="variable">chco</span> oraz <span class="variable">chd</span>.
W parametrze <span class="variable">chco</span> ustalamy gradient liniowy
przebiegający od koloru 
<span class="variable">ffdfbf</span> do koloru 
<span class="variable">512800</span>.
Poszczególne państwa będą pokolorowane 
jednym z odcieni tego gradientu.
Nasycenie gradientu zależy od wartości <span class="variable">chd</span>.
</p>


<p>
Kolor Polski jest wyznaczony przez wartość A,
która w kodowaniu prostym jest równa 0.
Zatem Polska jest pokolorowana kolorem startowym gradientu.
</p>


<p>
Kolor drugiego kraju, Niemiec, 
powstaje jako 31/61 nasycenie gradientu,
gdyż litera f w kodowaniu prostym to właśnie 31,
a największą wartością jest 61.
</p>



<p>
Kolorem Francji jest zdefiniowany w ciągu danych 
cyfrą 9, która w kodowaniu prostym ma wartość 61.
Otrzymujemy więc ułamek 61/61, czyli 1.
Francja jest więc pokolorowana ciemniejszym kolorem gradientu.
</p>

<p>
Największy możliwy wymiar mapy wynosi 440x220 pikseli.
</p>